/*
Code Support     : Board ET-USBPIC/4550
Compiler         : PIC C Compiler Version 3.249
Micro Controller : PIC18F4550
OSC              : 48MHz
*/

#include <18F4550.h>
#fuses HSPLL,USBDIV,PLL5,CPUDIV1,VREGEN,NOWDT,NOPROTECT,NOLVP,NODEBUG
#use   delay(clock=48000000)

#use        rs232(baud=9600, parity=N, xmit=PIN_C6, rcv=PIN_C7, bits=8) // Configuration RS232 port


void main() {

  int16 Dat;
  int8 AN0_Value,AN1_Value,AN2_Value,AN3_Value;


      set_tris_a(0B00001111);
      set_tris_c(0B10111111);
      setup_adc_ports(AN0_TO_AN3);                                        // Asign Analog pin
      setup_adc(ADC_CLOCK_INTERNAL);                                      

      printf("\fTest Analog to Digital Module");

   While (1)
   {
                    set_adc_channel(0);                                 // Select Channel AN0
                    delay_us(10);                                       
                    AN0_Value = read_adc();                             // Read adc channel 0 

                    set_adc_channel(1);                                 // Select Channel AN1
                    delay_us(10);                                       
                    AN1_Value = read_adc();                             // Read adc channel 1 

                    set_adc_channel(2);                                 // Select Channel AN2
                    delay_us(10);                                       
                    AN2_Value = read_adc();                             // Read adc channel 2 

                    set_adc_channel(3);                                 // Select Channel AN3
                    delay_us(10);                                       
                    AN3_Value = read_adc();                             // Read adc channel 3 

                    printf("\r\nAN0 = %u      AN1 = %u      AN2 = %u      AN3 = %u",AN0_Value,AN1_Value,AN2_Value,AN3_Value);
                    delay_ms(100);


   }
}
